﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.OData;
using System.Web.OData.Routing;
using Microsoft.Xrm.Sdk;
using PpmsDataService.V1.Mappers;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using System.Net;
using System.Net.Http;
using Microsoft.Web.Http;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class InstitutionsController : ODataController
    {
        [ODataRoute("Institutions('{key}')")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {                
                //Retrieve the Institution 
                var ppmsInstitution = context.ppms_institutionSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsInstitution != null)
                {
                    var ppmsInstitutionsList = new List<ppms_institution> { ppmsInstitution };
                    var institutions = await InstitutionMap.MapInstitutions(ppmsInstitutionsList, queryType, context);
                    return Request.CreateResponse(institutions);
                }
            }
            var message = string.Format("Institution with Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("Institutions('{key}')/Visn")]
        public async Task<HttpResponseMessage> GetVisn([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Institution 
                var ppmsInstitution = context.ppms_institutionSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsInstitution != null)
                {
                    //Get the related Visn
                    var ppmsVisn =
                        context.va_visnSet.FirstOrDefault(i => i.Id == ppmsInstitution.ppms_visn.Id);
                    var ppmsVisnList = new List<va_visn> { ppmsVisn };
                    var visn =
                        await VisnMap.MapVisns(ppmsVisnList, "None", context);
                    return Request.CreateResponse(visn);
                }
            }
            var message = string.Format("Visns with Institution Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("Institutions")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Institutions in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsInstitutions = context.ppms_institutionSet.Where(i => i.ppms_name != null).Take(50);
                var ppmsInstitutionsList = ppmsInstitutions.ToList();
                if (ppmsInstitutionsList.Any())
                {
                    //Map Institution
                    var institutions = await InstitutionMap.MapInstitutions(ppmsInstitutionsList, "None", context);
                    return Request.CreateResponse(institutions);
                }
                var message = "No Institutions found"; 
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }       
    }
}